<?php

$this->pageTitle = 'Zarządzanie rozwiązanymi zleceniami - '.Yii::app()->name;

$this->breadcrumbs = array(
	'Zlecenia'=>array('admin'),
	'Zarządzanie rozwiązanymi zleceniami - zlecenia klasy ' . $klasa->nazwa,
);

?>

<style>
	.fail {
		font-weight: bold;
		color: red;
	}
	.success {
		font-weight: bold;
		color: blue;
	}
	div[header-id] {
		font-weight: bold;
		cursor: pointer;
	}
	div[tresc-id] h1 {
		text-align:center;
	}
	div[tresc-id] img {
		max-width:80%;
	}
/*	#uzytkownik-zlecenia-lista a:hover {
		font-weight: initial;
	}*/
	#printAll, .taskOrderUpdate {
		cursor: pointer;
	}
	.pleaseCenterAlignThisColumnForMe {
		text-align: center
	}
	.orderListGroup
	{
		border: 1px solid #DDDCDC;
		border-radius: 5px;
		padding: 10px;
		margin-bottom: 10px;
		position: relative;
	}
	.orderListGroup legend {
		margin-left: 5px;
		font-weight: bold;
	}
	div.ui-datepicker.ui-widget.ui-widget-content a:hover {
		font-weight: initial
	}
	.buttonS.bDefault
	{
		color: #000;
		margin-bottom: 5px;
	}
</style>

<h2>Rozwiązane zlecenia klasy <?php echo $klasa->nazwa; ?> (<?php echo $klasa->szkola["nazwa"]; ?>)  <?php echo $companyName; ?></h2>
<br/>
<div class="form">
	<b>Firma:</b> <?php echo CHtml::dropDownList('companyId', 'Wybierz firmę', $firmy); ?>
	<?php echo CHtml::hiddenField('id', $klasa->id); ?>
	<a href="<?php echo Yii::app()->createUrl('/administration/zlecenie/solutionsClass', array('id'=>$klasa->id)); ?>" class="buttonS bGreen" id="filterLink">Filtruj</a>
</div>
<br/>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'uzytkownik-zlecenia-zgloszone-lista',
	'dataProvider'=> new CArrayDataProvider($zlecenia, array(
		'sort'=>array(
			'attributes'=>array('dataZakonczenia'),
		),
	)),
	'htmlOptions' => array('class' => 'tDefault'),
	'enableSorting'=>true,
	'columns'=>array(
		array(
			'header'=>'Id zlecenia',
			'name'=>'zlecenie',
			'type'=>'raw',
//			'value'=>'$data->idZlecenia'
			'value'=>'"<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/update", array("id"=>$data->idZlecenia)) . "\">$data->idZlecenia</a>"'
		),
		array(
			'header'=>'Dziedzina',
			'name'=>'dziedzina',
			'value'=>'"<img title=\"" . $data->idZlecenia0->dziedzina->nazwa . "\" alt=\"" . $data->idZlecenia0->dziedzina->nazwa .
				"\" src=\"" . $data->idZlecenia0->dziedzina->namesAsImageUrl . "\" />"',
			'type'=>'raw'
		),
		array(
			'header'=>'Kategoria',
			'name'=>'kategoria',
			'value'=>'$data->idZlecenia0->kategoria',
		),
		array(
			'header'=>'Poziom',
			'name'=>'poziom',
			'value'=>'$data->idZlecenia0->poziomStr',
		),
		array(
			'header'=>'Data',
			'name'=>'czasZakonczenia',
			'value'=>'$data->czasZakonczenia',
		),
		array(
			'header'=>'Użytkownik',
			'name'=>'user',
			'value'=>'$data->uczen["imie"]. " " .$data->uczen["nazwisko"]',
		),
		array(
			'header'=>'Akcje',
			'value'=>'"
				<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/resetReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Zresetuj zadanie</a><br/>
				<a href=\"" . ($data->idOdpowiedzi == null ?  Yii::app()->CreateUrl("/administration/zlecenie/acceptReportedSolution", array("id"=>$data->id)) : "#") . "\" class=\"buttonS bDefault\" ". ($data->idOdpowiedzi != null ? "style=\"color: #AAAAAA;\"" : "") .">Uznaj odpowiedź</a>
</td></tr><tr><td colspan=\"9\"><div header-id=\"" . $data->id ."\">Szczegóły</div><div tresc-id=\"" . $data->id ."\">" .
				(empty($data->idZlecenia0->urlObrazka) ? "" :
				"<h1><img src=\"" . Yii::app()->baseUrl."/".$data->idZlecenia0->urlObrazka . "\"/></h1>") .
				"<p>" . $data->idZlecenia0->tresc . "</p>
				<div><u>Odpowiedzi</u>: " . implode(", ", array_values(CHtml::listData($data->idZlecenia0->odpowiedziZlecenia, "id", "odpowiedz"))) . "</div>
				<div><u>Udzielona odpowiedź</u>: <i>" . ($data->odpowiedz == null ? "brak odpowiedzi" : $data->odpowiedz) .
					($data->idZlecenia0->jednostka==null?"":" [".$data->idZlecenia0->jednostka."]") . "</i></div>
				<br/>
				</div></td></tr>
				"',
			'type'=>'raw'
		),
	),
));
?>
<script type="text/javascript">
$(document).ready(function(){
	$("#companyId").change(function(){
		var link = "<?php echo Yii::app()->createUrl('/administration/zlecenie/solutionsClass', array('id'=>$klasa->id)); ?>";
		var companyId = $(this).val();
		if($(this).val() !== '')
			link += '/companyId/'+ companyId;

		$("#filterLink").attr("href", link);
	});
});
</script>